// V1.0	Original version Alastair Murray


sampler2D	depth_alias_texture : SAMPLER = sampler_state
{
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = None;
	AddressU  = Clamp;
	AddressV  = Clamp;
};
float4	ScreenSpaceOffset : register(c0);	// for each tile
float	EDRAM_TILE_WIDTH : register(c4);

struct VSINPUT
{
	float2 position : POSITION;
};


struct VSOUTPUT
{
	float4 position		: POSITION;
};

VSOUTPUT VSFunc( VSINPUT _input )
{
	VSOUTPUT _output;

	_output.position.xy = _input.position.xy;
	_output.position.z = 0.0f;
	_output.position.w = 1.0f;

	return _output;
}

float4 PSFunc( float2 ScreenPos : VPOS ) : COLOR0
{
	float	ColumnIndex = ScreenPos.x / EDRAM_TILE_WIDTH;
	float	HalfColumn = frac( ColumnIndex );
	float2	TexCoord = ScreenPos + ScreenSpaceOffset.xy;	// account for tiling
	if( HalfColumn >= 0.5 )
	{
		TexCoord.x -= ( EDRAM_TILE_WIDTH / 2 );
	}
	else
	{
		TexCoord.x += ( EDRAM_TILE_WIDTH / 2 );
	}

	float4	DepthData;
	asm
	{
		tfetch2D DepthData, TexCoord, depth_alias_texture, UnnormalizedTextureCoords = true
	};
	return DepthData.zyxw;
}




technique RestoreZ
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = false;
		AlphaTestEnable = false;
		VertexShader = compile vs_3_0 VSFunc();
		PixelShader = compile ps_3_0 PSFunc();
	}
}
